((PLUGIN_ID) => {
    'use strict';
    const conf = kintone.plugin.app.getConfig(PLUGIN_ID);
    const appId = kintone.app.getId();
    const elById = (id) => document.getElementById(id);
    const el = (tag) => document.createElement(tag);

    let opTag = '';
    let appFields = '';
    if (conf) {
        // フォーム情報取得
        kintone.api(kintone.api.url('/k/v1/preview/form', true), 'GET', {app: appId}, (resp) => {
            appFields = resp.properties;
            for (let i = 0; i < appFields.length; i++) {
                if (resp.properties[i]['type'] === 'SINGLE_LINE_TEXT') {
                    opTag = document.createElement('option');
                    opTag.value = appFields[i]['code'];
                    if (conf['folderName'] === appFields[i]['code']) {
                        opTag.selected = true;
                    }
                    opTag.textContent = appFields[i]['label'] + ' (' + appFields[i]['code'] + ')';
                    document.getElementById('folder-name').appendChild(opTag);
                }
                if (resp.properties[i]['type'] === 'SPACER') {
                    opTag = document.createElement('option');
                    opTag.value = appFields[i]['elementId'];
                    if (conf['listSpace'] === appFields[i]['code']) {
                        opTag.selected = true;
                    }
                    opTag.textContent = appFields[i]['elementId'];
                    document.getElementById('file-list-display').appendChild(opTag);
                }
                if (resp.properties[i]['type'] === 'MULTI_LINE_TEXT') {
                    opTag = document.createElement('option');
                    opTag.value = appFields[i]['code'];
                    if (conf['listSaveField'] === resp.properties[i]['code']) {
                        opTag.selected = true;
                    }
                    opTag.textContent = appFields[i]['label'] + '(' + appFields[i]['code'] + ')';
                    document.getElementById('file-list-save').appendChild(opTag);
                }
            }
            if (conf['checkFrag'] === 'YES') {
                var cb = document.getElementById('checkbox-0');
                if (cb) cb.checked = true;
            }
        });
    } else {
        // フォーム情報取得
        kintone.api(kintone.api.url('/k/v1/preview/form', true), 'GET', {app: appId}, function(resp) {
            appFields = resp.properties;
            for (let i = 0; i < appFields.length; i++) {
                if (resp.properties[i]['type'] === 'SINGLE_LINE_TEXT') {
                    opTag = document.createElement('option');
                    opTag.value = appFields[i]['code'];
                    opTag.textContent = appFields[i]['label'] + ' (' + appFields[i]['code'] + ')';
                    document.getElementById('folder-name').appendChild(opTag);
                }
                if (resp.properties[i]['type'] === 'SPACER') {
                    opTag = document.createElement('option');
                    opTag.value = appFields[i]['elementId'];
                    opTag.textContent = appFields[i]['elementId'];
                    document.getElementById('file-list-display').appendChild(opTag);
                }
                if (resp.properties[i]['type'] === 'MULTI_LINE_TEXT') {
                    opTag = document.createElement('option');
                    opTag.value = appFields[i]['code'];
                    opTag.textContent = appFields[i]['label'] + ' (' + appFields[i]['code'] + ')';
                    document.getElementById('file-list-save').appendChild(opTag);
                }
            }
        });
    }

    // 保存ボタンの処理
    document.getElementById('submit').addEventListener('click', function() {
        const config = {};
        const folderName = document.querySelector('select[id="folder-name"]').value;
        const spaceCode = document.querySelector('select[id="file-list-display"]').value;
        const saveCode = document.querySelector('select[id="file-list-save"]').value;

        let checkFrag = 'NO';
        var cb = document.getElementById('checkbox-0');
        if (cb && cb.checked) {
            checkFrag = 'YES';
        }

        if (!spaceCode || !saveCode || !folderName) {
            alert('必須項目が選択されていません');
            return;
        }
        config['folderName'] = folderName;
        config['listSpace'] = spaceCode;
        config['listSaveField'] = saveCode;
        config['checkFrag'] = checkFrag;
        kintone.plugin.app.setConfig(config);
    });

    // 「キャンセル」ボタン押下時の処理
    document.getElementById('cancel').addEventListener('click', function() {
        history.back();
    });
})(kintone.$PLUGIN_ID);
