/* globals klib */
((PLUGIN_ID) => {
    'use strict';
    const config = kintone.plugin.app.getConfig(PLUGIN_ID);
    const folderCode = config['folderName'];
    const listSpace = config['listSpace'];
    const listSaveFieldCode = config['listSaveField'];
    const checkFrag = config['checkFrag'];
    kintone.events.on(['app.record.index.edit.show'], (event) => {
        const record = event.record;
        record[listSaveFieldCode]['disabled'] = true;
        return event;
    });
    kintone.events.on('app.record.index.show', (event) => {
        const saveFieldEle = kintone.app.getFieldElements(listSaveFieldCode);
        if (saveFieldEle) {
            for (let i = 0; i < saveFieldEle.length; i++) {
                saveFieldEle[i]['innerHTML'] = '<div>このフィールドは表示できません</div>';
            }
        }
        if (document.getElementById('tokenBtn')) {
            return;
        }
        const tokenButton = klib.createBtn('', 'tokenBtn', 'kintoneplugin-button-normal');
        if (!kintone.oauth.hasAccessToken(klib.clientInfo)) {
            tokenButton.textContent = 'Dropbox Login';
            tokenButton.addEventListener('click', () => { klib.authenticate(); });
        } else {
            tokenButton.textContent = 'Dropbox Logout';
            tokenButton.addEventListener('click', () => { klib.clearAccessToken(); });
        }
        kintone.app.getHeaderMenuSpaceElement().appendChild(tokenButton);
    });
    kintone.events.on('app.record.detail.show', (event) => {
        const record = event.record;
        const folderName = record[folderCode]['value'];
        const spParts = kintone.app.record.getSpaceElement(listSpace);
        const divParts = document.createElement('div');
        divParts.className = 'dropbox-parts';

        // ファイルリスト非表示
        kintone.app.record.setFieldShown(listSaveFieldCode, false);
        if (kintone.oauth.hasAccessToken(klib.clientInfo)) {
            // メッセージ表示
            const spanMsg = document.createElement('span');
            spanMsg.textContent = 'Dropboxフォルダ内ファイルリスト';
            spParts.appendChild(spanMsg);
            // ファイルリストの表示
            const displayObj = record[listSaveFieldCode]['value'];
            divParts.innerHTML = displayObj;
            spParts.appendChild(divParts);
            // Updateボタン
            const updateBtn = klib.createBtn('Update', 'updateBtn', 'kintoneplugin-button-dialog-ok');
            spParts.appendChild(document.createElement('br'));
            spParts.appendChild(updateBtn);
            const updateBtnEl = document.getElementById('updateBtn');
            if (updateBtnEl) {
                updateBtnEl.addEventListener('click', () => {
                    klib.showSpinner();
                    const reqData = {
                        path: '/' + folderName
                    };
                    const appId = kintone.app.getId();
                    const recID = kintone.app.record.getId();
                    const updateRecord = (fieldValue) => {
                        const recordParm = {};
                        recordParm['app'] = appId;
                        recordParm['id'] = recID;
                        recordParm['record'] = {};
                        recordParm['record'][listSaveFieldCode] = {};
                        recordParm['record'][listSaveFieldCode]['value'] = fieldValue;
                        kintone.api(kintone.api.url('/k/v1/record', true), 'PUT', recordParm, (resp) => {
                            klib.hideSpinner();
                            location.reload();
                        });
                    }
                    if (!folderName) {
                        updateRecord('<p>フォルダ名が未入力です。</p>');
                    } else {
                        klib.requestDropBox2('/files/list_folder', 'POST', reqData).then((resp) => {
                            let fileNum = 0;
                            const fileNameArray = [];
                            const filePathArray = [];
                            const fileSizeArray = [];
                            let requestParam = '';
                            if (resp['error']) {
                                updateRecord('<p>Dropbox上にフォルダが確認できません。</p>');
                            }
                            for (let i = 0; i < resp['entries'].length; i++) {
                                if (resp['entries'][i]['.tag'] === 'file') {
                                    fileNum++;
                                    fileNameArray.push(resp['entries'][i]['name']);
                                    filePathArray.push(resp['entries'][i]['path_lower']);
                                    fileSizeArray.push(resp['entries'][i]['size']);
                                }
                            }
                            const getFileLinks = (indexNumber) => {
                                let indexNum = indexNumber || 0;
                                return klib.requestDropBox2('/sharing/create_shared_link', 'POST', {
                                    'path': filePathArray[indexNum]
                                }).then((resp2) => {
                                    let sharedLink = '';
                                    const sizeCalculate = (tmpFileSize) => {
                                        return (parseInt(tmpFileSize, 10) / 1024).toFixed(1);
                                    }
                                    fileSizeArray[indexNum] = sizeCalculate(fileSizeArray[indexNum]) + 'KB';
                                    if (parseFloat(fileSizeArray[indexNum], 10) > 1000) {
                                        fileSizeArray[indexNum] = sizeCalculate(fileSizeArray[indexNum]) + 'MB';
                                    }
                                    if (parseFloat(fileSizeArray[indexNum], 10) > 1000) {
                                        fileSizeArray[indexNum] = sizeCalculate(fileSizeArray[indexNum]) + 'GB';
                                    }
                                    if (checkFrag === 'YES') {
                                        sharedLink = (resp2.url).replace(/dl=0/g, 'dl=1');
                                    } else {
                                        sharedLink = resp2.url;
                                    }
                                    if (indexNum === 0) {
                                        requestParam += '<a href=' + sharedLink + ' target ="_blank">'
                                                        + fileNameArray[indexNum] + '</a>'
                                                        + '<span> (' + fileSizeArray[indexNum] + ')</span>';
                                    } else {
                                        requestParam += '<br/><a href=' + sharedLink + ' target ="_blank">'
                                                        + fileNameArray[indexNum] + '</a>'
                                                        + '<span> (' + fileSizeArray[indexNum] + ')</span>';
                                    }
                                    indexNum += 1;
                                    if (indexNum < fileNum) {
                                        getFileLinks(indexNum);
                                    } else {
                                        updateRecord(requestParam);
                                    }
                                });
                            }
                            if (fileNum > 0) {
                                getFileLinks();
                            } else {
                                updateRecord('<p>このフォルダにファイルは登録されていません。</p>');
                            }
                        });
                    }

                });
            } else {
                return;
            }
        } else {
            const pTemp = document.createElement('p');
            pTemp.textContent = '一覧画面上部のボタンよりDropboxにログインしてください';
            kintone.app.record.getHeaderMenuSpaceElement().appendChild(pTemp);
        }
    });
})(kintone.$PLUGIN_ID);
