/* globals klib */
((PLUGIN_ID) => {
  'use strict';
  const config = kintone.plugin.app.getConfig(PLUGIN_ID);
  const folderCode = config['folderName'];
  const listSpace = config['listSpace'];
  const listSaveFieldCode = config['listSaveField'];

  // レコード登録画面表示処理
  kintone.events.on('app.record.create.show', (event) => {
    const spParts = kintone.app.record.getSpaceElement(listSpace);

    const msgPtag = document.createElement('p');
    msgPtag.innerHTML = 'Dropboxにてフォルダを作成してください。';

    const divParts = document.createElement('div');
    divParts.className = 'dropbox-parts';

    divParts.appendChild(msgPtag);
    spParts.appendChild(divParts);

    // ファイルリスト非表示
    kintone.app.record.setFieldShown(listSaveFieldCode, false);
  });

  // レコード編集画面表示処理
  kintone.events.on('app.record.edit.show', (event) => {
    const record = event.record;
    const spParts = kintone.app.record.getSpaceElement(listSpace);

    const pMsg = document.createElement('p');
    pMsg.innerHTML = '<B>Dropboxフォルダ内ファイルリスト</B><br />※kintoneからファイル操作はできません。';

    const fileList = record[listSaveFieldCode]['value'];

    const divParts = document.createElement('div');
    divParts.className = 'dropbox-parts';

    // $(fileList).appendTo(divParts) の等価：HTML文字列をそのまま差し込む
    divParts.innerHTML = fileList;

    spParts.appendChild(pMsg);
    spParts.appendChild(divParts);

    // ファイルリスト非表示
    kintone.app.record.setFieldShown(listSaveFieldCode, false);
  });

  // レコード登録&編集 処理
  kintone.events.on(['app.record.create.submit', 'app.record.edit.submit'], (event) => {
    klib.showSpinner();
    // ファイルリスト非表示
    kintone.app.record.setFieldShown(listSaveFieldCode, false);

    const record = event.record;
    if (!record[folderCode]['value']) {
      klib.hideSpinner();
      if (confirm('フォルダ名が未入力です。\n レコードを保存しますか？')) {
        record[listSaveFieldCode]['value'] = '<p>フォルダ名が未入力です。</p>';
      } else {
        event.error = '保存がキャンセルされました';
      }
      return event;
    }

    const folerNameNew = klib.escapeHtml(record[folderCode]['value']);
    const listSaveField = record[listSaveFieldCode]['value'];
    const reqData = {
      path: '/' + folerNameNew
    };

    // 保存実行前の処理
    return klib.requestDropBox2('/files/list_folder', 'POST', reqData).then((resp) => {
      klib.hideSpinner();
      if (resp['error']) {
        if (confirm('Dropbox上にフォルダ ' + folerNameNew + ' がありません。\n レコードを保存しますか？')) {
          record[listSaveFieldCode]['value'] = '<p>Dropbox上にフォルダが確認できません。</p>';
        } else {
          event.error = '保存がキャンセルされました';
        }
      } else if (resp.entries.length === 0) {
        if (confirm('Dropbox上のフォルダ ' + folerNameNew + ' は空です。\n レコードを保存しますか？')) {
          record[listSaveFieldCode]['value'] = '<p>Dropboxのフォルダにファイルがありません。</p>';
        } else {
          event.error = '保存がキャンセルされました';
        }
      } else if (resp.entries.length > 0 && listSaveField) {
        record[listSaveFieldCode]['value'] = listSaveField;
      } else {
        record[listSaveFieldCode]['value'] = '<p>Updateボタンを押してリストを更新してください。</p>';
      }
    }).then(() => {
      return event;
    });
  });
})(kintone.$PLUGIN_ID);
