/* globals Spinner */
(() => {
  'use strict';

  // クライアント情報
  const clientInfo = {
    'provider': 'DROPBOX',
    'client': 'sr9qnwe36zf15ov'
  };

  // 認証リクエスト
  const authenticate = () => {
    return new kintone.Promise((resolve, reject) => {
      kintone.oauth.redirectToAuthenticate(clientInfo, window.location.href);
      reject();
    });
  };

  // 認証クリア
  const clearAccessToken = () => {
    kintone.oauth.clearAccessToken(clientInfo, () => {
      window.location.reload();
    });
    return new kintone.Promise((resolve, reject) => {
      reject();
    });
  };

  // Dropboxにリクエスト
  const requestDropBox2 = (url, method, opt_data) => {
    if (kintone.oauth.hasAccessToken(clientInfo)) {
      const reqUrl = 'https://api.dropbox.com/2' + url;
      const data = opt_data || {};
      const header = {'Content-Type': 'application/json'};
      return kintone.oauth.proxy(clientInfo, reqUrl, method, header, data)
        .then((resp) => {
          return JSON.parse(resp[0]);
        })
        .catch(() => {
          return clearAccessToken();
        });
    }
    return authenticate();
  };

  // スピナーを動作させる関数
  const showSpinner = () => {
    if (!document.querySelector('.kintone-spinner')) {
      const spinDiv = document.createElement('div');
      spinDiv.id = 'kintone-spin';
      spinDiv.className = 'kintone-spinner';
      spinDiv.innerHTML = '<div align="center"><b>Now Loading</b></div>';

      const spinBgDiv = document.createElement('div');
      spinBgDiv.id = 'kintone-spin-bg';
      spinBgDiv.className = 'kintone-spinner';

      document.body.append(spinDiv, spinBgDiv);

      Object.assign(spinDiv.style, {
        position: 'fixed',
        top: '50%',
        left: '50%',
        zIndex: '200',
        backgroundColor: '#fff',
        padding: '20px',
        borderRadius: '1px',
        transform: 'translate(-50%, -50%)'
      });
      Object.assign(spinBgDiv.style, {
        position: 'fixed',
        top: '0px',
        left: '0px',
        zIndex: '100',
        width: '100%',
        height: '100%',
        backgroundColor: '#000',
        opacity: '0.5'
      });

      const opts = { color: '#000' };
      new Spinner(opts).spin(document.getElementById('kintone-spin'));
    }
    document.querySelectorAll('.kintone-spinner').forEach(el => {
      el.style.display = 'block';
    });
  };

  // スピナーを停止させる関数
  const hideSpinner = () => {
    document.querySelectorAll('.kintone-spinner').forEach(el => {
      el.style.display = 'none';
    });
  };

  // ボタン作成関数（ネイティブ要素を返す）
  const createBtn = (innerStr, btnID, btnClass) => {
    const button = document.createElement('button');
    if (btnID) button.id = btnID;
    if (btnClass) button.className = btnClass;
    // もとの .html(innerStr) と同等にするため innerHTML を使用（挙動互換）
    button.innerHTML = innerStr || '';
    return button; // ← jQueryオブジェクトではなく DOM 要素を返す
  };

  // HTMLエスケープ
  const escapeHtml = (str) => {
    let tmpStr = str;
    tmpStr = tmpStr.replace(/&/g, '&amp;');
    tmpStr = tmpStr.replace(/</g, '&lt;');
    tmpStr = tmpStr.replace(/>/g, '&gt;');
    tmpStr = tmpStr.replace(/"/g, '&quot;');
    tmpStr = tmpStr.replace(/'/g, '&#39;');
    return tmpStr;
  };

  // 公開
  window.klib = window.klib || {};
  window.klib.clientInfo = clientInfo;
  window.klib.authenticate = authenticate;
  window.klib.clearAccessToken = clearAccessToken;
  window.klib.requestDropBox2 = requestDropBox2;
  window.klib.showSpinner = showSpinner;
  window.klib.hideSpinner = hideSpinner;
  window.klib.createBtn = createBtn;
  window.klib.escapeHtml = escapeHtml;
})();
